#include <iostream>
#include <vector>

const int N = 1e5 + 20;

using namespace std;
typedef long long ll;

struct line{
    int l, r, cnt;
};
line ln[N];
int dsu[N];

int find(int v){
    if(dsu[v] == v) return v;
    return dsu[v] = find(dsu[v]);
}

bool merge(int st, int ed){
    if(st == 0)
        return 1;
    //cout << "merge(" << st << ' ' << ed << ")\n";
    //cout << "cnt_st: " << ln[find(st)].cnt << ' ' << ln[find(ed)].cnt << '\n';
    if(ln[find(st)].r != st || ln[find(ed)].l != ed)
        return 0; // no cycle
    int dcnt = ln[find(ed)].cnt;
    st = find(st);
    dsu[find(ed)] = st;
    ln[st].r = ed;
    ln[st].cnt += dcnt;
    //cout << "rs: " << ln[st].l << ' ' << ln[st].r << ", cnt: " << ln[st].cnt << '\n';
    return 1;
}

int rs[N];
vector<int> g[N];
bool usd[N]{};
int cnt = 0, n;
int lsts = 0;
bool dfs(int v, bool fst, int cnt){
    //cout << "v: " << v + 1 << ", cnt: " << cnt  << '\n';
    if(v == lsts && !fst){
        if(cnt == n)
            return
            //cout << "return 1\n",
            1;
        else return
            //cout << "return 0\n",
            0;
    }
    if(g[v].size() == 1){
        if(ln[find(v)].l != v){
            //cout << "return 0\n";
            return 0;
        }
        //cout << "find(v).r: " << ln[find(v)].r << "\n";
        return dfs(ln[find(v)].r, 0, cnt + ln[find(v)].cnt - 1);
    }
    usd[v] = 1;
    bool cr = 0;
    for(auto i: g[v])
        if(dfs(i, 0, cnt + 1)){
            rs[v] = i;
            return 1;
        }
    usd[v] = 0;
    return 0;
}

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int m;
    cin >> n >> m;
    for(int i = 0; i < n; ++i)
        rs[i] = -1, dsu[i] = i;
    for(int i = 0; i < n; ++i)
        ln[i] = {i, i, 1};
    for(int i = 0, a, b; i < m; ++i){
        cin >> a >> b; --a; --b;
        g[a].push_back(b);
    }
    for(int i = 0; i < n; ++i)
        if(g[i].size() == 0){
            cout << "NO\n";
            return 0;
        }else if(g[i].size() == 1){
            rs[i] = g[i][0];
            //usd[g[i][0]] = 1;
            if(!merge(i, g[i][0])){
                cout << "NO\n";
                return 0;
            }
        }
    //*
    if(!dfs(0, 1, 0)){
        cout << "NO\n";
        return 0;
    }//*/
    else cout << "YES\n";
    int v = 0;
    cout << "1 ";
    v = rs[v];
    cout << v + 1 << ' ';
    while(v != 0){
        v = rs[v];
        cout << v + 1 << ' ';
    }
}

